/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.multipart;

import com.technicalitiesmc.lib.block.multipart.BlockSlot;
import com.technicalitiesmc.lib.block.multipart.IntersectionTestResult;
import com.technicalitiesmc.lib.block.multipart.MultipartBlock;
import com.technicalitiesmc.lib.block.multipart.MultipartBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface Multipart {
    @Nullable
    public BlockSlot getSlot(BlockState var1);

    default public VoxelShape getIntersectionShape(BlockState state, Level level, BlockPos pos, @Nullable BlockState other) {
        return state.m_60812_((BlockGetter)level, pos);
    }

    default public IntersectionTestResult testIntersection(BlockState state, Level level, BlockPos pos, BlockState other) {
        return IntersectionTestResult.PASS;
    }

    public static boolean testIntersectionBetween(Level level, BlockPos pos, BlockState first, BlockState second) {
        Block block = first.m_60734_();
        if (block instanceof Multipart) {
            Multipart multipart1 = (Multipart)block;
            block = second.m_60734_();
            if (block instanceof Multipart) {
                Multipart multipart2 = (Multipart)block;
                IntersectionTestResult result1 = multipart1.testIntersection(first, level, pos, second);
                if (result1 == IntersectionTestResult.INTERSECTION) {
                    return true;
                }
                IntersectionTestResult result2 = multipart2.testIntersection(second, level, pos, first);
                if (result2 == IntersectionTestResult.INTERSECTION) {
                    return true;
                }
                if (result1 == IntersectionTestResult.NO_INTERSECTION || result2 == IntersectionTestResult.NO_INTERSECTION) {
                    return false;
                }
                List shape1 = multipart1.getIntersectionShape(first, level, pos, second).m_83299_();
                List shape2 = multipart2.getIntersectionShape(second, level, pos, first).m_83299_();
                for (AABB aabb1 : shape1) {
                    for (AABB aabb2 : shape2) {
                        if (!aabb1.m_82381_(aabb2)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static boolean testIntersectionAgainst(Level level, BlockPos pos, AABB bounds, @Nullable BlockState self) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (state == self) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof Multipart) {
            Multipart multipart = (Multipart)block;
            List shape = multipart.getIntersectionShape(state, level, pos, self).m_83299_();
            for (AABB aabb : shape) {
                if (!aabb.m_82381_(bounds)) continue;
                return true;
            }
            return false;
        }
        if (state.m_60734_() instanceof MultipartBlock && (blockEntity = level.m_7702_(pos)) instanceof MultipartBlockEntity) {
            MultipartBlockEntity entity = (MultipartBlockEntity)blockEntity;
            return entity.testIntersection(bounds, self);
        }
        return true;
    }

    public static BlockState getBlockState(BlockGetter level, BlockPos pos, @Nullable BlockSlot slot) {
        BlockState state = level.m_8055_(pos);
        if (slot == null) {
            return state;
        }
        Block block = state.m_60734_();
        if (block instanceof Multipart) {
            Multipart multipart = (Multipart)block;
            return multipart.getSlot(state) == slot ? state : Blocks.f_50016_.m_49966_();
        }
        if (block instanceof MultipartBlock) {
            return ((MultipartBlockEntity)level.m_7702_(pos)).getState(slot);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public static BlockEntity getBlockEntity(BlockGetter level, BlockPos pos, @Nullable BlockSlot slot) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity == null || slot == null) {
            return entity;
        }
        if (entity instanceof MultipartBlockEntity) {
            MultipartBlockEntity mbe = (MultipartBlockEntity)entity;
            return mbe.getEntity(slot);
        }
        return null;
    }

    @Nullable
    public static BlockEntity getBlockEntity(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity == null || entity.m_58900_() == state) {
            return entity;
        }
        Block block = state.m_60734_();
        if (block instanceof Multipart) {
            Multipart multipart = (Multipart)block;
            if (entity instanceof MultipartBlockEntity) {
                MultipartBlockEntity mbe = (MultipartBlockEntity)entity;
                return mbe.getEntity(multipart.getSlot(state));
            }
        }
        return null;
    }
}

